package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetsRequest(
    names: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest = {
    import DescribeFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeFleetsRequest.wrap(buildAwsValue())
}
object DescribeFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeFleetsRequest =
      zio.aws.appstream.model.DescribeFleetsRequest(
        names.map(value => value),
        nextToken.map(value => value)
      )
    def names: Optional[List[String]]
    def nextToken: Optional[String]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ) extends zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly {
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ): zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly = new Wrapper(impl)
}
