package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeApplicationsResponse(
    applications: Optional[Iterable[zio.aws.appstream.model.Application]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse = {
    import DescribeApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeApplicationsResponse.wrap(buildAwsValue())
}
object DescribeApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeApplicationsResponse =
      zio.aws.appstream.model.DescribeApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applications
        : Optional[List[zio.aws.appstream.model.Application.ReadOnly]]
    def nextToken: Optional[String]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.Application.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse
  ) extends zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly {
    override val applications
        : Optional[List[zio.aws.appstream.model.Application.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Application.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse
  ): zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
