package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppBlockBuildersResponse(
    appBlockBuilders: Optional[
      Iterable[zio.aws.appstream.model.AppBlockBuilder]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse = {
    import DescribeAppBlockBuildersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse
      .builder()
      .optionallyWith(
        appBlockBuilders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appBlockBuilders)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeAppBlockBuildersResponse.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlockBuildersResponse
      .wrap(buildAwsValue())
}
object DescribeAppBlockBuildersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeAppBlockBuildersResponse =
      zio.aws.appstream.model.DescribeAppBlockBuildersResponse(
        appBlockBuilders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appBlockBuilders
        : Optional[List[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]]
    def nextToken: Optional[String]
    def getAppBlockBuilders: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AppBlockBuilder.ReadOnly
    ]] = AwsError.unwrapOptionField("appBlockBuilders", appBlockBuilders)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse
  ) extends zio.aws.appstream.model.DescribeAppBlockBuildersResponse.ReadOnly {
    override val appBlockBuilders
        : Optional[List[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AppBlockBuilder.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse
  ): zio.aws.appstream.model.DescribeAppBlockBuildersResponse.ReadOnly =
    new Wrapper(impl)
}
