package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppBlockBuildersRequest(
    names: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest = {
    import DescribeAppBlockBuildersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeAppBlockBuildersRequest.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlockBuildersRequest
      .wrap(buildAwsValue())
}
object DescribeAppBlockBuildersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeAppBlockBuildersRequest =
      zio.aws.appstream.model.DescribeAppBlockBuildersRequest(
        names.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def names: Optional[List[String]]
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest
  ) extends zio.aws.appstream.model.DescribeAppBlockBuildersRequest.ReadOnly {
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest
  ): zio.aws.appstream.model.DescribeAppBlockBuildersRequest.ReadOnly =
    new Wrapper(impl)
}
