package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppBlockBuilderAppBlockAssociationsResponse(
    appBlockBuilderAppBlockAssociations: Optional[
      Iterable[zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse = {
    import DescribeAppBlockBuilderAppBlockAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
      .builder()
      .optionallyWith(
        appBlockBuilderAppBlockAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appBlockBuilderAppBlockAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeAppBlockBuilderAppBlockAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse =
      zio.aws.appstream.model
        .DescribeAppBlockBuilderAppBlockAssociationsResponse(
          appBlockBuilderAppBlockAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def appBlockBuilderAppBlockAssociations: Optional[
      List[zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getAppBlockBuilderAppBlockAssociations: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appBlockBuilderAppBlockAssociations",
      appBlockBuilderAppBlockAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
  ) extends zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse.ReadOnly {
    override val appBlockBuilderAppBlockAssociations: Optional[
      List[zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockBuilderAppBlockAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse
  ): zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
