package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{AwsAccountId, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteImagePermissionsRequest(
    name: Name,
    sharedAccountId: AwsAccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest = {
    import DeleteImagePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .sharedAccountId(AwsAccountId.unwrap(sharedAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DeleteImagePermissionsRequest.ReadOnly =
    zio.aws.appstream.model.DeleteImagePermissionsRequest.wrap(buildAwsValue())
}
object DeleteImagePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteImagePermissionsRequest =
      zio.aws.appstream.model
        .DeleteImagePermissionsRequest(name, sharedAccountId)
    def name: Name
    def sharedAccountId: AwsAccountId
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSharedAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(sharedAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest
  ) extends zio.aws.appstream.model.DeleteImagePermissionsRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val sharedAccountId: AwsAccountId =
      zio.aws.appstream.model.primitives.AwsAccountId(impl.sharedAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest
  ): zio.aws.appstream.model.DeleteImagePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
