package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteImageBuilderRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest = {
    import DeleteImageBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteImageBuilderRequest.ReadOnly =
    zio.aws.appstream.model.DeleteImageBuilderRequest.wrap(buildAwsValue())
}
object DeleteImageBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteImageBuilderRequest =
      zio.aws.appstream.model.DeleteImageBuilderRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest
  ) extends zio.aws.appstream.model.DeleteImageBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest
  ): zio.aws.appstream.model.DeleteImageBuilderRequest.ReadOnly = new Wrapper(
    impl
  )
}
