package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppBlockBuilderRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteAppBlockBuilderRequest = {
    import DeleteAppBlockBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteAppBlockBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DeleteAppBlockBuilderRequest.ReadOnly =
    zio.aws.appstream.model.DeleteAppBlockBuilderRequest.wrap(buildAwsValue())
}
object DeleteAppBlockBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteAppBlockBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteAppBlockBuilderRequest =
      zio.aws.appstream.model.DeleteAppBlockBuilderRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteAppBlockBuilderRequest
  ) extends zio.aws.appstream.model.DeleteAppBlockBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteAppBlockBuilderRequest
  ): zio.aws.appstream.model.DeleteAppBlockBuilderRequest.ReadOnly =
    new Wrapper(impl)
}
