package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateImageBuilderStreamingUrlRequest(
    name: String,
    validity: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest = {
    import CreateImageBuilderStreamingUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(validity.map(value => value: java.lang.Long))(_.validity)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest.ReadOnly =
    zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest
      .wrap(buildAwsValue())
}
object CreateImageBuilderStreamingUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest =
      zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest(
        name,
        validity.map(value => value)
      )
    def name: String
    def validity: Optional[Long]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValidity: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("validity", validity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest
  ) extends zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val validity: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.validity())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest
  ): zio.aws.appstream.model.CreateImageBuilderStreamingUrlRequest.ReadOnly =
    new Wrapper(impl)
}
