package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDirectoryConfigResponse(
    directoryConfig: Optional[zio.aws.appstream.model.DirectoryConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse = {
    import CreateDirectoryConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse
      .builder()
      .optionallyWith(directoryConfig.map(value => value.buildAwsValue()))(
        _.directoryConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly =
    zio.aws.appstream.model.CreateDirectoryConfigResponse.wrap(buildAwsValue())
}
object CreateDirectoryConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateDirectoryConfigResponse =
      zio.aws.appstream.model.CreateDirectoryConfigResponse(
        directoryConfig.map(value => value.asEditable)
      )
    def directoryConfig
        : Optional[zio.aws.appstream.model.DirectoryConfig.ReadOnly]
    def getDirectoryConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.DirectoryConfig.ReadOnly] =
      AwsError.unwrapOptionField("directoryConfig", directoryConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse
  ) extends zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly {
    override val directoryConfig
        : Optional[zio.aws.appstream.model.DirectoryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryConfig())
        .map(value => zio.aws.appstream.model.DirectoryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse
  ): zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly =
    new Wrapper(impl)
}
