package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    application: Optional[zio.aws.appstream.model.Application] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateApplicationResponse.ReadOnly =
    zio.aws.appstream.model.CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateApplicationResponse =
      zio.aws.appstream.model
        .CreateApplicationResponse(application.map(value => value.asEditable))
    def application: Optional[zio.aws.appstream.model.Application.ReadOnly]
    def getApplication
        : ZIO[Any, AwsError, zio.aws.appstream.model.Application.ReadOnly] =
      AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateApplicationResponse
  ) extends zio.aws.appstream.model.CreateApplicationResponse.ReadOnly {
    override val application
        : Optional[zio.aws.appstream.model.Application.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.application())
        .map(value => zio.aws.appstream.model.Application.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateApplicationResponse
  ): zio.aws.appstream.model.CreateApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
