package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  TagValue,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppBlockRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    sourceS3Location: zio.aws.appstream.model.S3Location,
    setupScriptDetails: Optional[zio.aws.appstream.model.ScriptDetails] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    postSetupScriptDetails: Optional[zio.aws.appstream.model.ScriptDetails] =
      Optional.Absent,
    packagingType: Optional[zio.aws.appstream.model.PackagingType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest = {
    import CreateAppBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .sourceS3Location(sourceS3Location.buildAwsValue())
      .optionallyWith(setupScriptDetails.map(value => value.buildAwsValue()))(
        _.setupScriptDetails
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        postSetupScriptDetails.map(value => value.buildAwsValue())
      )(_.postSetupScriptDetails)
      .optionallyWith(packagingType.map(value => value.unwrap))(_.packagingType)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockRequest.wrap(buildAwsValue())
}
object CreateAppBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateAppBlockRequest =
      zio.aws.appstream.model.CreateAppBlockRequest(
        name,
        description.map(value => value),
        displayName.map(value => value),
        sourceS3Location.asEditable,
        setupScriptDetails.map(value => value.asEditable),
        tags.map(value => value),
        postSetupScriptDetails.map(value => value.asEditable),
        packagingType.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def sourceS3Location: zio.aws.appstream.model.S3Location.ReadOnly
    def setupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def postSetupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly]
    def packagingType: Optional[zio.aws.appstream.model.PackagingType]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSourceS3Location
        : ZIO[Any, Nothing, zio.aws.appstream.model.S3Location.ReadOnly] =
      ZIO.succeed(sourceS3Location)
    def getSetupScriptDetails
        : ZIO[Any, AwsError, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      AwsError.unwrapOptionField("setupScriptDetails", setupScriptDetails)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPostSetupScriptDetails
        : ZIO[Any, AwsError, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      AwsError.unwrapOptionField(
        "postSetupScriptDetails",
        postSetupScriptDetails
      )
    def getPackagingType
        : ZIO[Any, AwsError, zio.aws.appstream.model.PackagingType] =
      AwsError.unwrapOptionField("packagingType", packagingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ) extends zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val sourceS3Location: zio.aws.appstream.model.S3Location.ReadOnly =
      zio.aws.appstream.model.S3Location.wrap(impl.sourceS3Location())
    override val setupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setupScriptDetails())
        .map(value => zio.aws.appstream.model.ScriptDetails.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val postSetupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postSetupScriptDetails())
        .map(value => zio.aws.appstream.model.ScriptDetails.wrap(value))
    override val packagingType
        : Optional[zio.aws.appstream.model.PackagingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packagingType())
        .map(value => zio.aws.appstream.model.PackagingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest
  ): zio.aws.appstream.model.CreateAppBlockRequest.ReadOnly = new Wrapper(impl)
}
