package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppBlockBuilderStreamingUrlRequest(
    appBlockBuilderName: Name,
    validity: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest = {
    import CreateAppBlockBuilderStreamingUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
      .builder()
      .appBlockBuilderName(Name.unwrap(appBlockBuilderName): java.lang.String)
      .optionallyWith(validity.map(value => value: java.lang.Long))(_.validity)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
      .wrap(buildAwsValue())
}
object CreateAppBlockBuilderStreamingUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest =
      zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest(
        appBlockBuilderName,
        validity.map(value => value)
      )
    def appBlockBuilderName: Name
    def validity: Optional[Long]
    def getAppBlockBuilderName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(appBlockBuilderName)
    def getValidity: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("validity", validity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
  ) extends zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest.ReadOnly {
    override val appBlockBuilderName: Name =
      zio.aws.appstream.model.primitives.Name(impl.appBlockBuilderName())
    override val validity: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.validity())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderStreamingUrlRequest
  ): zio.aws.appstream.model.CreateAppBlockBuilderStreamingUrlRequest.ReadOnly =
    new Wrapper(impl)
}
