package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppBlockBuilderRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    platform: zio.aws.appstream.model.AppBlockBuilderPlatformType,
    instanceType: String,
    vpcConfig: zio.aws.appstream.model.VpcConfig,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderRequest = {
    import CreateAppBlockBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .platform(platform.unwrap)
      .instanceType(instanceType: java.lang.String)
      .vpcConfig(vpcConfig.buildAwsValue())
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateAppBlockBuilderRequest.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockBuilderRequest.wrap(buildAwsValue())
}
object CreateAppBlockBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateAppBlockBuilderRequest =
      zio.aws.appstream.model.CreateAppBlockBuilderRequest(
        name,
        description.map(value => value),
        displayName.map(value => value),
        tags.map(value => value),
        platform,
        instanceType,
        vpcConfig.asEditable,
        enableDefaultInternetAccess.map(value => value),
        iamRoleArn.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def tags: Optional[Map[TagKey, TagValue]]
    def platform: zio.aws.appstream.model.AppBlockBuilderPlatformType
    def instanceType: String
    def vpcConfig: zio.aws.appstream.model.VpcConfig.ReadOnly
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def iamRoleArn: Optional[Arn]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPlatform: ZIO[
      Any,
      Nothing,
      zio.aws.appstream.model.AppBlockBuilderPlatformType
    ] = ZIO.succeed(platform)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getVpcConfig
        : ZIO[Any, Nothing, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      ZIO.succeed(vpcConfig)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderRequest
  ) extends zio.aws.appstream.model.CreateAppBlockBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val platform: zio.aws.appstream.model.AppBlockBuilderPlatformType =
      zio.aws.appstream.model.AppBlockBuilderPlatformType.wrap(impl.platform())
    override val instanceType: String = impl.instanceType(): String
    override val vpcConfig: zio.aws.appstream.model.VpcConfig.ReadOnly =
      zio.aws.appstream.model.VpcConfig.wrap(impl.vpcConfig())
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderRequest
  ): zio.aws.appstream.model.CreateAppBlockBuilderRequest.ReadOnly =
    new Wrapper(impl)
}
