package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateFleetRequest(fleetName: String, stackName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AssociateFleetRequest = {
    import AssociateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AssociateFleetRequest
      .builder()
      .fleetName(fleetName: java.lang.String)
      .stackName(stackName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.AssociateFleetRequest.ReadOnly =
    zio.aws.appstream.model.AssociateFleetRequest.wrap(buildAwsValue())
}
object AssociateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AssociateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AssociateFleetRequest =
      zio.aws.appstream.model.AssociateFleetRequest(fleetName, stackName)
    def fleetName: String
    def stackName: String
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AssociateFleetRequest
  ) extends zio.aws.appstream.model.AssociateFleetRequest.ReadOnly {
    override val fleetName: String = impl.fleetName(): String
    override val stackName: String = impl.stackName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AssociateFleetRequest
  ): zio.aws.appstream.model.AssociateFleetRequest.ReadOnly = new Wrapper(impl)
}
