package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppBlockBuilderPlatformType {
  def unwrap: software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType
}
object AppBlockBuilderPlatformType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType
  ): zio.aws.appstream.model.AppBlockBuilderPlatformType = value match {
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType.WINDOWS_SERVER_2019 =>
      val r = WINDOWS_SERVER_2019
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppBlockBuilderPlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS_SERVER_2019
      extends zio.aws.appstream.model.AppBlockBuilderPlatformType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType.WINDOWS_SERVER_2019
  }
}
