package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AppBlock(
    name: String,
    arn: Arn,
    description: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    sourceS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    setupScriptDetails: Optional[zio.aws.appstream.model.ScriptDetails] =
      Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    postSetupScriptDetails: Optional[zio.aws.appstream.model.ScriptDetails] =
      Optional.Absent,
    packagingType: Optional[zio.aws.appstream.model.PackagingType] =
      Optional.Absent,
    state: Optional[zio.aws.appstream.model.AppBlockState] = Optional.Absent,
    appBlockErrors: Optional[Iterable[zio.aws.appstream.model.ErrorDetails]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AppBlock = {
    import AppBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AppBlock
      .builder()
      .name(name: java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(sourceS3Location.map(value => value.buildAwsValue()))(
        _.sourceS3Location
      )
      .optionallyWith(setupScriptDetails.map(value => value.buildAwsValue()))(
        _.setupScriptDetails
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        postSetupScriptDetails.map(value => value.buildAwsValue())
      )(_.postSetupScriptDetails)
      .optionallyWith(packagingType.map(value => value.unwrap))(_.packagingType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        appBlockErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appBlockErrors)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.AppBlock.ReadOnly =
    zio.aws.appstream.model.AppBlock.wrap(buildAwsValue())
}
object AppBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AppBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AppBlock =
      zio.aws.appstream.model.AppBlock(
        name,
        arn,
        description.map(value => value),
        displayName.map(value => value),
        sourceS3Location.map(value => value.asEditable),
        setupScriptDetails.map(value => value.asEditable),
        createdTime.map(value => value),
        postSetupScriptDetails.map(value => value.asEditable),
        packagingType.map(value => value),
        state.map(value => value),
        appBlockErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: String
    def arn: Arn
    def description: Optional[String]
    def displayName: Optional[String]
    def sourceS3Location: Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def setupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly]
    def createdTime: Optional[Timestamp]
    def postSetupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly]
    def packagingType: Optional[zio.aws.appstream.model.PackagingType]
    def state: Optional[zio.aws.appstream.model.AppBlockState]
    def appBlockErrors
        : Optional[List[zio.aws.appstream.model.ErrorDetails.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSourceS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Location", sourceS3Location)
    def getSetupScriptDetails
        : ZIO[Any, AwsError, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      AwsError.unwrapOptionField("setupScriptDetails", setupScriptDetails)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getPostSetupScriptDetails
        : ZIO[Any, AwsError, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      AwsError.unwrapOptionField(
        "postSetupScriptDetails",
        postSetupScriptDetails
      )
    def getPackagingType
        : ZIO[Any, AwsError, zio.aws.appstream.model.PackagingType] =
      AwsError.unwrapOptionField("packagingType", packagingType)
    def getState: ZIO[Any, AwsError, zio.aws.appstream.model.AppBlockState] =
      AwsError.unwrapOptionField("state", state)
    def getAppBlockErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ErrorDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("appBlockErrors", appBlockErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AppBlock
  ) extends zio.aws.appstream.model.AppBlock.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Arn = zio.aws.appstream.model.primitives.Arn(impl.arn())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val sourceS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val setupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setupScriptDetails())
        .map(value => zio.aws.appstream.model.ScriptDetails.wrap(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val postSetupScriptDetails
        : Optional[zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postSetupScriptDetails())
        .map(value => zio.aws.appstream.model.ScriptDetails.wrap(value))
    override val packagingType
        : Optional[zio.aws.appstream.model.PackagingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packagingType())
        .map(value => zio.aws.appstream.model.PackagingType.wrap(value))
    override val state: Optional[zio.aws.appstream.model.AppBlockState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.appstream.model.AppBlockState.wrap(value))
    override val appBlockErrors
        : Optional[List[zio.aws.appstream.model.ErrorDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.ErrorDetails.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AppBlock
  ): zio.aws.appstream.model.AppBlock.ReadOnly = new Wrapper(impl)
}
