package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppBlockBuilderResponse(
    appBlockBuilder: Optional[zio.aws.appstream.model.AppBlockBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderResponse = {
    import UpdateAppBlockBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderResponse
      .builder()
      .optionallyWith(appBlockBuilder.map(value => value.buildAwsValue()))(
        _.appBlockBuilder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.UpdateAppBlockBuilderResponse.ReadOnly =
    zio.aws.appstream.model.UpdateAppBlockBuilderResponse.wrap(buildAwsValue())
}
object UpdateAppBlockBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateAppBlockBuilderResponse =
      zio.aws.appstream.model.UpdateAppBlockBuilderResponse(
        appBlockBuilder.map(value => value.asEditable)
      )
    def appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]
    def getAppBlockBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      AwsError.unwrapOptionField("appBlockBuilder", appBlockBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderResponse
  ) extends zio.aws.appstream.model.UpdateAppBlockBuilderResponse.ReadOnly {
    override val appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilder())
        .map(value => zio.aws.appstream.model.AppBlockBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderResponse
  ): zio.aws.appstream.model.UpdateAppBlockBuilderResponse.ReadOnly =
    new Wrapper(impl)
}
