package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopAppBlockBuilderResponse(
    appBlockBuilder: Optional[zio.aws.appstream.model.AppBlockBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderResponse = {
    import StopAppBlockBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderResponse
      .builder()
      .optionallyWith(appBlockBuilder.map(value => value.buildAwsValue()))(
        _.appBlockBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StopAppBlockBuilderResponse.ReadOnly =
    zio.aws.appstream.model.StopAppBlockBuilderResponse.wrap(buildAwsValue())
}
object StopAppBlockBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StopAppBlockBuilderResponse =
      zio.aws.appstream.model.StopAppBlockBuilderResponse(
        appBlockBuilder.map(value => value.asEditable)
      )
    def appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]
    def getAppBlockBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      AwsError.unwrapOptionField("appBlockBuilder", appBlockBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderResponse
  ) extends zio.aws.appstream.model.StopAppBlockBuilderResponse.ReadOnly {
    override val appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilder())
        .map(value => zio.aws.appstream.model.AppBlockBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StopAppBlockBuilderResponse
  ): zio.aws.appstream.model.StopAppBlockBuilderResponse.ReadOnly = new Wrapper(
    impl
  )
}
