package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStackRequest(name: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteStackRequest = {
    import DeleteStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteStackRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteStackRequest.ReadOnly =
    zio.aws.appstream.model.DeleteStackRequest.wrap(buildAwsValue())
}
object DeleteStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteStackRequest =
      zio.aws.appstream.model.DeleteStackRequest(name)
    def name: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteStackRequest
  ) extends zio.aws.appstream.model.DeleteStackRequest.ReadOnly {
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteStackRequest
  ): zio.aws.appstream.model.DeleteStackRequest.ReadOnly = new Wrapper(impl)
}
