package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppBlockBuilderResponse(
    appBlockBuilder: Optional[zio.aws.appstream.model.AppBlockBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderResponse = {
    import CreateAppBlockBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderResponse
      .builder()
      .optionallyWith(appBlockBuilder.map(value => value.buildAwsValue()))(
        _.appBlockBuilder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CreateAppBlockBuilderResponse.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockBuilderResponse.wrap(buildAwsValue())
}
object CreateAppBlockBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateAppBlockBuilderResponse =
      zio.aws.appstream.model.CreateAppBlockBuilderResponse(
        appBlockBuilder.map(value => value.asEditable)
      )
    def appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]
    def getAppBlockBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      AwsError.unwrapOptionField("appBlockBuilder", appBlockBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderResponse
  ) extends zio.aws.appstream.model.CreateAppBlockBuilderResponse.ReadOnly {
    override val appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilder())
        .map(value => zio.aws.appstream.model.AppBlockBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockBuilderResponse
  ): zio.aws.appstream.model.CreateAppBlockBuilderResponse.ReadOnly =
    new Wrapper(impl)
}
