package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateAppBlockBuilderAppBlockResponse(
    appBlockBuilderAppBlockAssociation: Optional[
      zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse = {
    import AssociateAppBlockBuilderAppBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse
      .builder()
      .optionallyWith(
        appBlockBuilderAppBlockAssociation.map(value => value.buildAwsValue())
      )(_.appBlockBuilderAppBlockAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse.ReadOnly =
    zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse
      .wrap(buildAwsValue())
}
object AssociateAppBlockBuilderAppBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse =
      zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse(
        appBlockBuilderAppBlockAssociation.map(value => value.asEditable)
      )
    def appBlockBuilderAppBlockAssociation: Optional[
      zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly
    ]
    def getAppBlockBuilderAppBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appBlockBuilderAppBlockAssociation",
      appBlockBuilderAppBlockAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse
  ) extends zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse.ReadOnly {
    override val appBlockBuilderAppBlockAssociation: Optional[
      zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockBuilderAppBlockAssociation())
      .map(value =>
        zio.aws.appstream.model.AppBlockBuilderAppBlockAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockResponse
  ): zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockResponse.ReadOnly =
    new Wrapper(impl)
}
