package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppBlockState {
  def unwrap: software.amazon.awssdk.services.appstream.model.AppBlockState
}
object AppBlockState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppBlockState
  ): zio.aws.appstream.model.AppBlockState = value match {
    case software.amazon.awssdk.services.appstream.model.AppBlockState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockState.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appstream.model.AppBlockState.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppBlockState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockState =
      software.amazon.awssdk.services.appstream.model.AppBlockState.UNKNOWN_TO_SDK_VERSION
  }
  case object INACTIVE extends zio.aws.appstream.model.AppBlockState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockState =
      software.amazon.awssdk.services.appstream.model.AppBlockState.INACTIVE
  }
  case object ACTIVE extends zio.aws.appstream.model.AppBlockState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockState =
      software.amazon.awssdk.services.appstream.model.AppBlockState.ACTIVE
  }
}
