package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UserSetting(
    action: zio.aws.appstream.model.Action,
    permission: zio.aws.appstream.model.Permission
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UserSetting = {
    import UserSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UserSetting
      .builder()
      .action(action.unwrap)
      .permission(permission.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UserSetting.ReadOnly =
    zio.aws.appstream.model.UserSetting.wrap(buildAwsValue())
}
object UserSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UserSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UserSetting =
      zio.aws.appstream.model.UserSetting(action, permission)
    def action: zio.aws.appstream.model.Action
    def permission: zio.aws.appstream.model.Permission
    def getAction: ZIO[Any, Nothing, zio.aws.appstream.model.Action] =
      ZIO.succeed(action)
    def getPermission: ZIO[Any, Nothing, zio.aws.appstream.model.Permission] =
      ZIO.succeed(permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UserSetting
  ) extends zio.aws.appstream.model.UserSetting.ReadOnly {
    override val action: zio.aws.appstream.model.Action =
      zio.aws.appstream.model.Action.wrap(impl.action())
    override val permission: zio.aws.appstream.model.Permission =
      zio.aws.appstream.model.Permission.wrap(impl.permission())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UserSetting
  ): zio.aws.appstream.model.UserSetting.ReadOnly = new Wrapper(impl)
}
