package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  Arn,
  Description,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppBlockBuilderRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    platform: Optional[zio.aws.appstream.model.PlatformType] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent,
    attributesToDelete: Optional[
      Iterable[zio.aws.appstream.model.AppBlockBuilderAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderRequest = {
    import UpdateAppBlockBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.UpdateAppBlockBuilderRequest.ReadOnly =
    zio.aws.appstream.model.UpdateAppBlockBuilderRequest.wrap(buildAwsValue())
}
object UpdateAppBlockBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateAppBlockBuilderRequest =
      zio.aws.appstream.model.UpdateAppBlockBuilderRequest(
        name,
        description.map(value => value),
        displayName.map(value => value),
        platform.map(value => value),
        instanceType.map(value => value),
        vpcConfig.map(value => value.asEditable),
        enableDefaultInternetAccess.map(value => value),
        iamRoleArn.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributesToDelete.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def platform: Optional[zio.aws.appstream.model.PlatformType]
    def instanceType: Optional[String]
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def iamRoleArn: Optional[Arn]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def attributesToDelete
        : Optional[List[zio.aws.appstream.model.AppBlockBuilderAttribute]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getAttributesToDelete: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AppBlockBuilderAttribute
    ]] = AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderRequest
  ) extends zio.aws.appstream.model.UpdateAppBlockBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val platform: Optional[zio.aws.appstream.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
    override val attributesToDelete
        : Optional[List[zio.aws.appstream.model.AppBlockBuilderAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AppBlockBuilderAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateAppBlockBuilderRequest
  ): zio.aws.appstream.model.UpdateAppBlockBuilderRequest.ReadOnly =
    new Wrapper(impl)
}
