package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamingExperienceSettings(
    preferredProtocol: Optional[zio.aws.appstream.model.PreferredProtocol] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings = {
    import StreamingExperienceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings
      .builder()
      .optionallyWith(preferredProtocol.map(value => value.unwrap))(
        _.preferredProtocol
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly =
    zio.aws.appstream.model.StreamingExperienceSettings.wrap(buildAwsValue())
}
object StreamingExperienceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StreamingExperienceSettings =
      zio.aws.appstream.model
        .StreamingExperienceSettings(preferredProtocol.map(value => value))
    def preferredProtocol: Optional[zio.aws.appstream.model.PreferredProtocol]
    def getPreferredProtocol
        : ZIO[Any, AwsError, zio.aws.appstream.model.PreferredProtocol] =
      AwsError.unwrapOptionField("preferredProtocol", preferredProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings
  ) extends zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly {
    override val preferredProtocol
        : Optional[zio.aws.appstream.model.PreferredProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredProtocol())
        .map(value => zio.aws.appstream.model.PreferredProtocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings
  ): zio.aws.appstream.model.StreamingExperienceSettings.ReadOnly = new Wrapper(
    impl
  )
}
