package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartAppBlockBuilderResponse(
    appBlockBuilder: Optional[zio.aws.appstream.model.AppBlockBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderResponse = {
    import StartAppBlockBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderResponse
      .builder()
      .optionallyWith(appBlockBuilder.map(value => value.buildAwsValue()))(
        _.appBlockBuilder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.StartAppBlockBuilderResponse.ReadOnly =
    zio.aws.appstream.model.StartAppBlockBuilderResponse.wrap(buildAwsValue())
}
object StartAppBlockBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StartAppBlockBuilderResponse =
      zio.aws.appstream.model.StartAppBlockBuilderResponse(
        appBlockBuilder.map(value => value.asEditable)
      )
    def appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly]
    def getAppBlockBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      AwsError.unwrapOptionField("appBlockBuilder", appBlockBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderResponse
  ) extends zio.aws.appstream.model.StartAppBlockBuilderResponse.ReadOnly {
    override val appBlockBuilder
        : Optional[zio.aws.appstream.model.AppBlockBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilder())
        .map(value => zio.aws.appstream.model.AppBlockBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StartAppBlockBuilderResponse
  ): zio.aws.appstream.model.StartAppBlockBuilderResponse.ReadOnly =
    new Wrapper(impl)
}
