package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, Name, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppBlockBuilderAppBlockAssociationsRequest(
    appBlockArn: Optional[Arn] = Optional.Absent,
    appBlockBuilderName: Optional[Name] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest = {
    import DescribeAppBlockBuilderAppBlockAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
      .builder()
      .optionallyWith(
        appBlockArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appBlockArn)
      .optionallyWith(
        appBlockBuilderName.map(value => Name.unwrap(value): java.lang.String)
      )(_.appBlockBuilderName)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeAppBlockBuilderAppBlockAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest =
      zio.aws.appstream.model
        .DescribeAppBlockBuilderAppBlockAssociationsRequest(
          appBlockArn.map(value => value),
          appBlockBuilderName.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def appBlockArn: Optional[Arn]
    def appBlockBuilderName: Optional[Name]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getAppBlockArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appBlockArn", appBlockArn)
    def getAppBlockBuilderName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("appBlockBuilderName", appBlockBuilderName)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
  ) extends zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest.ReadOnly {
    override val appBlockArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val appBlockBuilderName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockBuilderName())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest
  ): zio.aws.appstream.model.DescribeAppBlockBuilderAppBlockAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
