package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyImageResponse(
    destinationImageName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CopyImageResponse = {
    import CopyImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CopyImageResponse
      .builder()
      .optionallyWith(
        destinationImageName.map(value => Name.unwrap(value): java.lang.String)
      )(_.destinationImageName)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CopyImageResponse.ReadOnly =
    zio.aws.appstream.model.CopyImageResponse.wrap(buildAwsValue())
}
object CopyImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CopyImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CopyImageResponse =
      zio.aws.appstream.model
        .CopyImageResponse(destinationImageName.map(value => value))
    def destinationImageName: Optional[Name]
    def getDestinationImageName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("destinationImageName", destinationImageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CopyImageResponse
  ) extends zio.aws.appstream.model.CopyImageResponse.ReadOnly {
    override val destinationImageName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationImageName())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CopyImageResponse
  ): zio.aws.appstream.model.CopyImageResponse.ReadOnly = new Wrapper(impl)
}
