package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Name, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateAppBlockBuilderAppBlockRequest(
    appBlockArn: Arn,
    appBlockBuilderName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest = {
    import AssociateAppBlockBuilderAppBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest
      .builder()
      .appBlockArn(Arn.unwrap(appBlockArn): java.lang.String)
      .appBlockBuilderName(Name.unwrap(appBlockBuilderName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest.ReadOnly =
    zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest
      .wrap(buildAwsValue())
}
object AssociateAppBlockBuilderAppBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest =
      zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest(
        appBlockArn,
        appBlockBuilderName
      )
    def appBlockArn: Arn
    def appBlockBuilderName: Name
    def getAppBlockArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(appBlockArn)
    def getAppBlockBuilderName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(appBlockBuilderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest
  ) extends zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest.ReadOnly {
    override val appBlockArn: Arn =
      zio.aws.appstream.model.primitives.Arn(impl.appBlockArn())
    override val appBlockBuilderName: Name =
      zio.aws.appstream.model.primitives.Name(impl.appBlockBuilderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AssociateAppBlockBuilderAppBlockRequest
  ): zio.aws.appstream.model.AssociateAppBlockBuilderAppBlockRequest.ReadOnly =
    new Wrapper(impl)
}
