package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppBlockBuilderStateChangeReasonCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode
}
object AppBlockBuilderStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode
  ): zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode =
    value match {
      case software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode.INTERNAL_ERROR =>
        val r = INTERNAL_ERROR
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.appstream.model.AppBlockBuilderStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReasonCode.INTERNAL_ERROR
  }
}
