package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, BooleanObject, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AppBlockBuilder(
    arn: Arn,
    name: String,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    platform: zio.aws.appstream.model.AppBlockBuilderPlatformType,
    instanceType: String,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    vpcConfig: zio.aws.appstream.model.VpcConfig,
    state: zio.aws.appstream.model.AppBlockBuilderState,
    createdTime: Optional[Timestamp] = Optional.Absent,
    appBlockBuilderErrors: Optional[
      Iterable[zio.aws.appstream.model.ResourceError]
    ] = Optional.Absent,
    stateChangeReason: Optional[
      zio.aws.appstream.model.AppBlockBuilderStateChangeReason
    ] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AppBlockBuilder = {
    import AppBlockBuilder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AppBlockBuilder
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .platform(platform.unwrap)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .vpcConfig(vpcConfig.buildAwsValue())
      .state(state.unwrap)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        appBlockBuilderErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appBlockBuilderErrors)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.AppBlockBuilder.ReadOnly =
    zio.aws.appstream.model.AppBlockBuilder.wrap(buildAwsValue())
}
object AppBlockBuilder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AppBlockBuilder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AppBlockBuilder =
      zio.aws.appstream.model.AppBlockBuilder(
        arn,
        name,
        displayName.map(value => value),
        description.map(value => value),
        platform,
        instanceType,
        enableDefaultInternetAccess.map(value => value),
        iamRoleArn.map(value => value),
        vpcConfig.asEditable,
        state,
        createdTime.map(value => value),
        appBlockBuilderErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stateChangeReason.map(value => value.asEditable),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def name: String
    def displayName: Optional[String]
    def description: Optional[String]
    def platform: zio.aws.appstream.model.AppBlockBuilderPlatformType
    def instanceType: String
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def iamRoleArn: Optional[Arn]
    def vpcConfig: zio.aws.appstream.model.VpcConfig.ReadOnly
    def state: zio.aws.appstream.model.AppBlockBuilderState
    def createdTime: Optional[Timestamp]
    def appBlockBuilderErrors
        : Optional[List[zio.aws.appstream.model.ResourceError.ReadOnly]]
    def stateChangeReason: Optional[
      zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly
    ]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[
      Any,
      Nothing,
      zio.aws.appstream.model.AppBlockBuilderPlatformType
    ] = ZIO.succeed(platform)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getVpcConfig
        : ZIO[Any, Nothing, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      ZIO.succeed(vpcConfig)
    def getState
        : ZIO[Any, Nothing, zio.aws.appstream.model.AppBlockBuilderState] =
      ZIO.succeed(state)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getAppBlockBuilderErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ResourceError.ReadOnly
    ]] =
      AwsError.unwrapOptionField("appBlockBuilderErrors", appBlockBuilderErrors)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AppBlockBuilder
  ) extends zio.aws.appstream.model.AppBlockBuilder.ReadOnly {
    override val arn: Arn = zio.aws.appstream.model.primitives.Arn(impl.arn())
    override val name: String = impl.name(): String
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val platform: zio.aws.appstream.model.AppBlockBuilderPlatformType =
      zio.aws.appstream.model.AppBlockBuilderPlatformType.wrap(impl.platform())
    override val instanceType: String = impl.instanceType(): String
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val vpcConfig: zio.aws.appstream.model.VpcConfig.ReadOnly =
      zio.aws.appstream.model.VpcConfig.wrap(impl.vpcConfig())
    override val state: zio.aws.appstream.model.AppBlockBuilderState =
      zio.aws.appstream.model.AppBlockBuilderState.wrap(impl.state())
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val appBlockBuilderErrors
        : Optional[List[zio.aws.appstream.model.ResourceError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlockBuilderErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.ResourceError.wrap(item)
          }.toList
        )
    override val stateChangeReason: Optional[
      zio.aws.appstream.model.AppBlockBuilderStateChangeReason.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stateChangeReason())
      .map(value =>
        zio.aws.appstream.model.AppBlockBuilderStateChangeReason.wrap(value)
      )
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AppBlockBuilder
  ): zio.aws.appstream.model.AppBlockBuilder.ReadOnly = new Wrapper(impl)
}
