package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Username
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserStackAssociation(
    stackName: String,
    userName: Username,
    authenticationType: zio.aws.appstream.model.AuthenticationType,
    sendEmailNotification: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UserStackAssociation = {
    import UserStackAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UserStackAssociation
      .builder()
      .stackName(stackName: java.lang.String)
      .userName(Username.unwrap(userName): java.lang.String)
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(
        sendEmailNotification.map(value => value: java.lang.Boolean)
      )(_.sendEmailNotification)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UserStackAssociation.ReadOnly =
    zio.aws.appstream.model.UserStackAssociation.wrap(buildAwsValue())
}
object UserStackAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UserStackAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UserStackAssociation =
      zio.aws.appstream.model.UserStackAssociation(
        stackName,
        userName,
        authenticationType,
        sendEmailNotification.map(value => value)
      )
    def stackName: String
    def userName: Username
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def sendEmailNotification: Optional[Boolean]
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getUserName: ZIO[Any, Nothing, Username] = ZIO.succeed(userName)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
    def getSendEmailNotification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sendEmailNotification", sendEmailNotification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociation
  ) extends zio.aws.appstream.model.UserStackAssociation.ReadOnly {
    override val stackName: String = impl.stackName(): String
    override val userName: Username =
      zio.aws.appstream.model.primitives.Username(impl.userName())
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
    override val sendEmailNotification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendEmailNotification())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociation
  ): zio.aws.appstream.model.UserStackAssociation.ReadOnly = new Wrapper(impl)
}
