package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateBasedAuthProperties(
    status: Optional[zio.aws.appstream.model.CertificateBasedAuthStatus] =
      Optional.Absent,
    certificateAuthorityArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties = {
    import CertificateBasedAuthProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.CertificateBasedAuthProperties.ReadOnly =
    zio.aws.appstream.model.CertificateBasedAuthProperties.wrap(buildAwsValue())
}
object CertificateBasedAuthProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CertificateBasedAuthProperties =
      zio.aws.appstream.model.CertificateBasedAuthProperties(
        status.map(value => value),
        certificateAuthorityArn.map(value => value)
      )
    def status: Optional[zio.aws.appstream.model.CertificateBasedAuthStatus]
    def certificateAuthorityArn: Optional[Arn]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.CertificateBasedAuthStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties
  ) extends zio.aws.appstream.model.CertificateBasedAuthProperties.ReadOnly {
    override val status
        : Optional[zio.aws.appstream.model.CertificateBasedAuthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.appstream.model.CertificateBasedAuthStatus.wrap(value)
        )
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CertificateBasedAuthProperties
  ): zio.aws.appstream.model.CertificateBasedAuthProperties.ReadOnly =
    new Wrapper(impl)
}
