package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeApplicationFleetAssociationsResponse(
    applicationFleetAssociations: Optional[
      Iterable[zio.aws.appstream.model.ApplicationFleetAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse = {
    import DescribeApplicationFleetAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
      .builder()
      .optionallyWith(
        applicationFleetAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationFleetAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationFleetAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse =
      zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse(
        applicationFleetAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationFleetAssociations: Optional[
      List[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getApplicationFleetAssociations: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationFleetAssociations",
      applicationFleetAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ) extends zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly {
    override val applicationFleetAssociations: Optional[
      List[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationFleetAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.ApplicationFleetAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse
  ): zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
