package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait StorageConnectorType {
  def unwrap
      : software.amazon.awssdk.services.appstream.model.StorageConnectorType
}
object StorageConnectorType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.StorageConnectorType
  ): zio.aws.appstream.model.StorageConnectorType = value match {
    case software.amazon.awssdk.services.appstream.model.StorageConnectorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.StorageConnectorType.HOMEFOLDERS =>
      val r = HOMEFOLDERS
      r
    case software.amazon.awssdk.services.appstream.model.StorageConnectorType.GOOGLE_DRIVE =>
      val r = GOOGLE_DRIVE
      r
    case software.amazon.awssdk.services.appstream.model.StorageConnectorType.ONE_DRIVE =>
      val r = ONE_DRIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.StorageConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StorageConnectorType =
      software.amazon.awssdk.services.appstream.model.StorageConnectorType.UNKNOWN_TO_SDK_VERSION
  }
  case object HOMEFOLDERS extends zio.aws.appstream.model.StorageConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StorageConnectorType =
      software.amazon.awssdk.services.appstream.model.StorageConnectorType.HOMEFOLDERS
  }
  case object GOOGLE_DRIVE
      extends zio.aws.appstream.model.StorageConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StorageConnectorType =
      software.amazon.awssdk.services.appstream.model.StorageConnectorType.GOOGLE_DRIVE
  }
  case object ONE_DRIVE extends zio.aws.appstream.model.StorageConnectorType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StorageConnectorType =
      software.amazon.awssdk.services.appstream.model.StorageConnectorType.ONE_DRIVE
  }
}
