package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssociatedFleetsRequest(
    stackName: String,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest = {
    import ListAssociatedFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest
      .builder()
      .stackName(stackName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ListAssociatedFleetsRequest.ReadOnly =
    zio.aws.appstream.model.ListAssociatedFleetsRequest.wrap(buildAwsValue())
}
object ListAssociatedFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ListAssociatedFleetsRequest =
      zio.aws.appstream.model
        .ListAssociatedFleetsRequest(stackName, nextToken.map(value => value))
    def stackName: String
    def nextToken: Optional[String]
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest
  ) extends zio.aws.appstream.model.ListAssociatedFleetsRequest.ReadOnly {
    override val stackName: String = impl.stackName(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest
  ): zio.aws.appstream.model.ListAssociatedFleetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
