package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppBlockResponse(
    appBlock: Optional[zio.aws.appstream.model.AppBlock] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse = {
    import CreateAppBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse
      .builder()
      .optionallyWith(appBlock.map(value => value.buildAwsValue()))(_.appBlock)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly =
    zio.aws.appstream.model.CreateAppBlockResponse.wrap(buildAwsValue())
}
object CreateAppBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateAppBlockResponse =
      zio.aws.appstream.model
        .CreateAppBlockResponse(appBlock.map(value => value.asEditable))
    def appBlock: Optional[zio.aws.appstream.model.AppBlock.ReadOnly]
    def getAppBlock
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppBlock.ReadOnly] =
      AwsError.unwrapOptionField("appBlock", appBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse
  ) extends zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly {
    override val appBlock: Optional[zio.aws.appstream.model.AppBlock.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBlock())
        .map(value => zio.aws.appstream.model.AppBlock.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse
  ): zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly = new Wrapper(impl)
}
