package zio.aws.appstream
import zio.aws.appstream.model.UpdateStackResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.appstream.model.{
  DeleteUserRequest,
  UpdateEntitlementRequest,
  UpdateApplicationRequest,
  DescribeUsersRequest,
  DeleteImagePermissionsRequest,
  CopyImageRequest,
  DescribeStacksRequest,
  CreateImageBuilderRequest,
  DeleteApplicationRequest,
  DescribeUsageReportSubscriptionsRequest,
  EnableUserRequest,
  AssociateFleetRequest,
  UpdateImagePermissionsRequest,
  DescribeFleetsRequest,
  DescribeDirectoryConfigsRequest,
  ExpireSessionRequest,
  DeleteEntitlementRequest,
  DescribeImagePermissionsRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteImageRequest,
  AssociateApplicationFleetRequest,
  CreateEntitlementRequest,
  CreateImageBuilderStreamingUrlRequest,
  DeleteStackRequest,
  DescribeSessionsRequest,
  DescribeApplicationsRequest,
  DescribeUserStackAssociationsRequest,
  UpdateDirectoryConfigRequest,
  StartImageBuilderRequest,
  DisassociateApplicationFromEntitlementRequest,
  DeleteImageBuilderRequest,
  CreateUsageReportSubscriptionRequest,
  DescribeApplicationFleetAssociationsRequest,
  CreateUserRequest,
  AssociateApplicationToEntitlementRequest,
  UpdateFleetRequest,
  CreateFleetRequest,
  CreateStreamingUrlRequest,
  ListEntitledApplicationsRequest,
  DeleteAppBlockRequest,
  CreateAppBlockRequest,
  CreateUpdatedImageRequest,
  UntagResourceRequest,
  DisassociateFleetRequest,
  DescribeImageBuildersRequest,
  DescribeImagesRequest,
  StartFleetRequest,
  StopImageBuilderRequest,
  ListAssociatedStacksRequest,
  CreateDirectoryConfigRequest,
  BatchAssociateUserStackRequest,
  BatchDisassociateUserStackRequest,
  StopFleetRequest,
  ListAssociatedFleetsRequest,
  DescribeEntitlementsRequest,
  DisableUserRequest,
  DescribeAppBlocksRequest,
  UpdateStackRequest,
  CreateStackRequest,
  TagResourceRequest,
  DeleteFleetRequest,
  DeleteDirectoryConfigRequest,
  DisassociateApplicationFleetRequest,
  DeleteUsageReportSubscriptionRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object AppStreamMock extends Mock[AppStream] {
  object DescribeEntitlements
      extends Stream[
        DescribeEntitlementsRequest,
        AwsError,
        zio.aws.appstream.model.Entitlement.ReadOnly
      ]
  object DescribeEntitlementsPaginated
      extends Effect[
        DescribeEntitlementsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly
      ]
  object StopImageBuilder
      extends Effect[
        StopImageBuilderRequest,
        AwsError,
        zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly
      ]
  object BatchAssociateUserStack
      extends Effect[
        BatchAssociateUserStackRequest,
        AwsError,
        zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly
      ]
  object DescribeStacks
      extends Stream[
        DescribeStacksRequest,
        AwsError,
        zio.aws.appstream.model.Stack.ReadOnly
      ]
  object DescribeStacksPaginated
      extends Effect[
        DescribeStacksRequest,
        AwsError,
        zio.aws.appstream.model.DescribeStacksResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.appstream.model.DeleteApplicationResponse.ReadOnly
      ]
  object DescribeSessions
      extends Stream[
        DescribeSessionsRequest,
        AwsError,
        zio.aws.appstream.model.Session.ReadOnly
      ]
  object DescribeSessionsPaginated
      extends Effect[
        DescribeSessionsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly
      ]
  object DeleteDirectoryConfig
      extends Effect[
        DeleteDirectoryConfigRequest,
        AwsError,
        zio.aws.appstream.model.DeleteDirectoryConfigResponse.ReadOnly
      ]
  object DisassociateApplicationFleet
      extends Effect[
        DisassociateApplicationFleetRequest,
        AwsError,
        zio.aws.appstream.model.DisassociateApplicationFleetResponse.ReadOnly
      ]
  object DescribeImagePermissions
      extends Effect[
        DescribeImagePermissionsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly,
          zio.aws.appstream.model.SharedImagePermissions.ReadOnly
        ]
      ]
  object DescribeImagePermissionsPaginated
      extends Effect[
        DescribeImagePermissionsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly
      ]
  object CreateEntitlement
      extends Effect[
        CreateEntitlementRequest,
        AwsError,
        zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly
      ]
  object DeleteUsageReportSubscription
      extends Effect[
        DeleteUsageReportSubscriptionRequest,
        AwsError,
        zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.ReadOnly
      ]
  object StartFleet
      extends Effect[
        StartFleetRequest,
        AwsError,
        zio.aws.appstream.model.StartFleetResponse.ReadOnly
      ]
  object CreateUsageReportSubscription
      extends Effect[
        CreateUsageReportSubscriptionRequest,
        AwsError,
        zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly
      ]
  object DeleteEntitlement
      extends Effect[
        DeleteEntitlementRequest,
        AwsError,
        zio.aws.appstream.model.DeleteEntitlementResponse.ReadOnly
      ]
  object DescribeFleets
      extends Stream[
        DescribeFleetsRequest,
        AwsError,
        zio.aws.appstream.model.Fleet.ReadOnly
      ]
  object DescribeFleetsPaginated
      extends Effect[
        DescribeFleetsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly
      ]
  object DescribeUsageReportSubscriptions
      extends Stream[
        DescribeUsageReportSubscriptionsRequest,
        AwsError,
        zio.aws.appstream.model.UsageReportSubscription.ReadOnly
      ]
  object DescribeUsageReportSubscriptionsPaginated
      extends Effect[
        DescribeUsageReportSubscriptionsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly
      ]
  object DeleteImage
      extends Effect[
        DeleteImageRequest,
        AwsError,
        zio.aws.appstream.model.DeleteImageResponse.ReadOnly
      ]
  object DeleteImageBuilder
      extends Effect[
        DeleteImageBuilderRequest,
        AwsError,
        zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly
      ]
  object DescribeImageBuilders
      extends Stream[
        DescribeImageBuildersRequest,
        AwsError,
        zio.aws.appstream.model.ImageBuilder.ReadOnly
      ]
  object DescribeImageBuildersPaginated
      extends Effect[
        DescribeImageBuildersRequest,
        AwsError,
        zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly
      ]
  object AssociateFleet
      extends Effect[
        AssociateFleetRequest,
        AwsError,
        zio.aws.appstream.model.AssociateFleetResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.appstream.model.CreateApplicationResponse.ReadOnly
      ]
  object CreateUpdatedImage
      extends Effect[
        CreateUpdatedImageRequest,
        AwsError,
        zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly
      ]
  object DeleteAppBlock
      extends Effect[
        DeleteAppBlockRequest,
        AwsError,
        zio.aws.appstream.model.DeleteAppBlockResponse.ReadOnly
      ]
  object AssociateApplicationToEntitlement
      extends Effect[
        AssociateApplicationToEntitlementRequest,
        AwsError,
        zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.ReadOnly
      ]
  object DescribeAppBlocks
      extends Stream[
        DescribeAppBlocksRequest,
        AwsError,
        zio.aws.appstream.model.AppBlock.ReadOnly
      ]
  object DescribeAppBlocksPaginated
      extends Effect[
        DescribeAppBlocksRequest,
        AwsError,
        zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly
      ]
  object DeleteFleet
      extends Effect[
        DeleteFleetRequest,
        AwsError,
        zio.aws.appstream.model.DeleteFleetResponse.ReadOnly
      ]
  object AssociateApplicationFleet
      extends Effect[
        AssociateApplicationFleetRequest,
        AwsError,
        zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly
      ]
  object CreateImageBuilder
      extends Effect[
        CreateImageBuilderRequest,
        AwsError,
        zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.appstream.model.CreateUserResponse.ReadOnly
      ]
  object UpdateFleet
      extends Effect[
        UpdateFleetRequest,
        AwsError,
        zio.aws.appstream.model.UpdateFleetResponse.ReadOnly
      ]
  object DescribeImages
      extends Stream[
        DescribeImagesRequest,
        AwsError,
        zio.aws.appstream.model.Image.ReadOnly
      ]
  object DescribeImagesPaginated
      extends Effect[
        DescribeImagesRequest,
        AwsError,
        zio.aws.appstream.model.DescribeImagesResponse.ReadOnly
      ]
  object CreateDirectoryConfig
      extends Effect[
        CreateDirectoryConfigRequest,
        AwsError,
        zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.appstream.model.CreateFleetResponse.ReadOnly
      ]
  object ExpireSession
      extends Effect[
        ExpireSessionRequest,
        AwsError,
        zio.aws.appstream.model.ExpireSessionResponse.ReadOnly
      ]
  object ListEntitledApplications
      extends Stream[
        ListEntitledApplicationsRequest,
        AwsError,
        zio.aws.appstream.model.EntitledApplication.ReadOnly
      ]
  object ListEntitledApplicationsPaginated
      extends Effect[
        ListEntitledApplicationsRequest,
        AwsError,
        zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly
      ]
  object CreateStreamingURL
      extends Effect[
        CreateStreamingUrlRequest,
        AwsError,
        zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly
      ]
  object UpdateEntitlement
      extends Effect[
        UpdateEntitlementRequest,
        AwsError,
        zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly
      ]
  object DisableUser
      extends Effect[
        DisableUserRequest,
        AwsError,
        zio.aws.appstream.model.DisableUserResponse.ReadOnly
      ]
  object DisassociateFleet
      extends Effect[
        DisassociateFleetRequest,
        AwsError,
        zio.aws.appstream.model.DisassociateFleetResponse.ReadOnly
      ]
  object CreateAppBlock
      extends Effect[
        CreateAppBlockRequest,
        AwsError,
        zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly
      ]
  object DisassociateApplicationFromEntitlement
      extends Effect[
        DisassociateApplicationFromEntitlementRequest,
        AwsError,
        zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.ReadOnly
      ]
  object DescribeUsers
      extends Stream[
        DescribeUsersRequest,
        AwsError,
        zio.aws.appstream.model.User.ReadOnly
      ]
  object DescribeUsersPaginated
      extends Effect[
        DescribeUsersRequest,
        AwsError,
        zio.aws.appstream.model.DescribeUsersResponse.ReadOnly
      ]
  object DescribeApplicationFleetAssociations
      extends Stream[
        DescribeApplicationFleetAssociationsRequest,
        AwsError,
        zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
      ]
  object DescribeApplicationFleetAssociationsPaginated
      extends Effect[
        DescribeApplicationFleetAssociationsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appstream.model.UntagResourceResponse.ReadOnly
      ]
  object CreateImageBuilderStreamingURL
      extends Effect[
        CreateImageBuilderStreamingUrlRequest,
        AwsError,
        zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.ReadOnly
      ]
  object StartImageBuilder
      extends Effect[
        StartImageBuilderRequest,
        AwsError,
        zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly
      ]
  object DescribeApplications
      extends Stream[
        DescribeApplicationsRequest,
        AwsError,
        zio.aws.appstream.model.Application.ReadOnly
      ]
  object DescribeApplicationsPaginated
      extends Effect[
        DescribeApplicationsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly
      ]
  object EnableUser
      extends Effect[
        EnableUserRequest,
        AwsError,
        zio.aws.appstream.model.EnableUserResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appstream.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CopyImage
      extends Effect[
        CopyImageRequest,
        AwsError,
        zio.aws.appstream.model.CopyImageResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appstream.model.TagResourceResponse.ReadOnly
      ]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.appstream.model.DeleteUserResponse.ReadOnly
      ]
  object ListAssociatedFleets
      extends Stream[ListAssociatedFleetsRequest, AwsError, String]
  object ListAssociatedFleetsPaginated
      extends Effect[
        ListAssociatedFleetsRequest,
        AwsError,
        zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly
      ]
  object UpdateStack extends Effect[UpdateStackRequest, AwsError, ReadOnly]
  object DeleteStack
      extends Effect[
        DeleteStackRequest,
        AwsError,
        zio.aws.appstream.model.DeleteStackResponse.ReadOnly
      ]
  object UpdateImagePermissions
      extends Effect[
        UpdateImagePermissionsRequest,
        AwsError,
        zio.aws.appstream.model.UpdateImagePermissionsResponse.ReadOnly
      ]
  object DeleteImagePermissions
      extends Effect[
        DeleteImagePermissionsRequest,
        AwsError,
        zio.aws.appstream.model.DeleteImagePermissionsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly
      ]
  object CreateStack
      extends Effect[
        CreateStackRequest,
        AwsError,
        zio.aws.appstream.model.CreateStackResponse.ReadOnly
      ]
  object BatchDisassociateUserStack
      extends Effect[
        BatchDisassociateUserStackRequest,
        AwsError,
        zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly
      ]
  object DescribeUserStackAssociations
      extends Stream[
        DescribeUserStackAssociationsRequest,
        AwsError,
        zio.aws.appstream.model.UserStackAssociation.ReadOnly
      ]
  object DescribeUserStackAssociationsPaginated
      extends Effect[
        DescribeUserStackAssociationsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly
      ]
  object ListAssociatedStacks
      extends Stream[ListAssociatedStacksRequest, AwsError, String]
  object ListAssociatedStacksPaginated
      extends Effect[
        ListAssociatedStacksRequest,
        AwsError,
        zio.aws.appstream.model.ListAssociatedStacksResponse.ReadOnly
      ]
  object DescribeDirectoryConfigs
      extends Stream[
        DescribeDirectoryConfigsRequest,
        AwsError,
        zio.aws.appstream.model.DirectoryConfig.ReadOnly
      ]
  object DescribeDirectoryConfigsPaginated
      extends Effect[
        DescribeDirectoryConfigsRequest,
        AwsError,
        zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly
      ]
  object StopFleet
      extends Effect[
        StopFleetRequest,
        AwsError,
        zio.aws.appstream.model.StopFleetResponse.ReadOnly
      ]
  object UpdateDirectoryConfig
      extends Effect[
        UpdateDirectoryConfigRequest,
        AwsError,
        zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppStream] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppStream] { rts =>
        ZIO.succeed {
          new AppStream {
            val api: AppStreamAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppStream = this
            def describeEntitlements(
                request: DescribeEntitlementsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.Entitlement.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeEntitlements, request))
            def describeEntitlementsPaginated(
                request: DescribeEntitlementsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly
            ] = proxy(DescribeEntitlementsPaginated, request)
            def stopImageBuilder(request: StopImageBuilderRequest): IO[
              AwsError,
              zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly
            ] = proxy(StopImageBuilder, request)
            def batchAssociateUserStack(
                request: BatchAssociateUserStackRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly
            ] = proxy(BatchAssociateUserStack, request)
            def describeStacks(
                request: DescribeStacksRequest
            ): ZStream[Any, AwsError, zio.aws.appstream.model.Stack.ReadOnly] =
              rts.unsafeRun(proxy(DescribeStacks, request))
            def describeStacksPaginated(request: DescribeStacksRequest): IO[
              AwsError,
              zio.aws.appstream.model.DescribeStacksResponse.ReadOnly
            ] = proxy(DescribeStacksPaginated, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def describeSessions(request: DescribeSessionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.Session.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeSessions, request))
            def describeSessionsPaginated(request: DescribeSessionsRequest): IO[
              AwsError,
              zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly
            ] = proxy(DescribeSessionsPaginated, request)
            def deleteDirectoryConfig(
                request: DeleteDirectoryConfigRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DeleteDirectoryConfigResponse.ReadOnly
            ] = proxy(DeleteDirectoryConfig, request)
            def disassociateApplicationFleet(
                request: DisassociateApplicationFleetRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DisassociateApplicationFleetResponse.ReadOnly
            ] = proxy(DisassociateApplicationFleet, request)
            def describeImagePermissions(
                request: DescribeImagePermissionsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly,
              zio.aws.appstream.model.SharedImagePermissions.ReadOnly
            ]] = proxy(DescribeImagePermissions, request)
            def describeImagePermissionsPaginated(
                request: DescribeImagePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly
            ] = proxy(DescribeImagePermissionsPaginated, request)
            def createEntitlement(request: CreateEntitlementRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly
            ] = proxy(CreateEntitlement, request)
            def deleteUsageReportSubscription(
                request: DeleteUsageReportSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.ReadOnly
            ] = proxy(DeleteUsageReportSubscription, request)
            def startFleet(request: StartFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.StartFleetResponse.ReadOnly
            ] = proxy(StartFleet, request)
            def createUsageReportSubscription(
                request: CreateUsageReportSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly
            ] = proxy(CreateUsageReportSubscription, request)
            def deleteEntitlement(request: DeleteEntitlementRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteEntitlementResponse.ReadOnly
            ] = proxy(DeleteEntitlement, request)
            def describeFleets(
                request: DescribeFleetsRequest
            ): ZStream[Any, AwsError, zio.aws.appstream.model.Fleet.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFleets, request))
            def describeFleetsPaginated(request: DescribeFleetsRequest): IO[
              AwsError,
              zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly
            ] = proxy(DescribeFleetsPaginated, request)
            def describeUsageReportSubscriptions(
                request: DescribeUsageReportSubscriptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.UsageReportSubscription.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeUsageReportSubscriptions, request))
            def describeUsageReportSubscriptionsPaginated(
                request: DescribeUsageReportSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly
            ] = proxy(DescribeUsageReportSubscriptionsPaginated, request)
            def deleteImage(request: DeleteImageRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteImageResponse.ReadOnly
            ] = proxy(DeleteImage, request)
            def deleteImageBuilder(request: DeleteImageBuilderRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly
            ] = proxy(DeleteImageBuilder, request)
            def describeImageBuilders(
                request: DescribeImageBuildersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.ImageBuilder.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeImageBuilders, request))
            def describeImageBuildersPaginated(
                request: DescribeImageBuildersRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly
            ] = proxy(DescribeImageBuildersPaginated, request)
            def associateFleet(request: AssociateFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.AssociateFleetResponse.ReadOnly
            ] = proxy(AssociateFleet, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def createUpdatedImage(request: CreateUpdatedImageRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly
            ] = proxy(CreateUpdatedImage, request)
            def deleteAppBlock(request: DeleteAppBlockRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteAppBlockResponse.ReadOnly
            ] = proxy(DeleteAppBlock, request)
            def associateApplicationToEntitlement(
                request: AssociateApplicationToEntitlementRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.ReadOnly
            ] = proxy(AssociateApplicationToEntitlement, request)
            def describeAppBlocks(request: DescribeAppBlocksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.AppBlock.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeAppBlocks, request))
            def describeAppBlocksPaginated(
                request: DescribeAppBlocksRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly
            ] = proxy(DescribeAppBlocksPaginated, request)
            def deleteFleet(request: DeleteFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteFleetResponse.ReadOnly
            ] = proxy(DeleteFleet, request)
            def associateApplicationFleet(
                request: AssociateApplicationFleetRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly
            ] = proxy(AssociateApplicationFleet, request)
            def createImageBuilder(request: CreateImageBuilderRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly
            ] = proxy(CreateImageBuilder, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def updateFleet(request: UpdateFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.UpdateFleetResponse.ReadOnly
            ] = proxy(UpdateFleet, request)
            def describeImages(
                request: DescribeImagesRequest
            ): ZStream[Any, AwsError, zio.aws.appstream.model.Image.ReadOnly] =
              rts.unsafeRun(proxy(DescribeImages, request))
            def describeImagesPaginated(request: DescribeImagesRequest): IO[
              AwsError,
              zio.aws.appstream.model.DescribeImagesResponse.ReadOnly
            ] = proxy(DescribeImagesPaginated, request)
            def createDirectoryConfig(
                request: CreateDirectoryConfigRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly
            ] = proxy(CreateDirectoryConfig, request)
            def createFleet(request: CreateFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateFleetResponse.ReadOnly
            ] = proxy(CreateFleet, request)
            def expireSession(request: ExpireSessionRequest): IO[
              AwsError,
              zio.aws.appstream.model.ExpireSessionResponse.ReadOnly
            ] = proxy(ExpireSession, request)
            def listEntitledApplications(
                request: ListEntitledApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.EntitledApplication.ReadOnly
            ] = rts.unsafeRun(proxy(ListEntitledApplications, request))
            def listEntitledApplicationsPaginated(
                request: ListEntitledApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly
            ] = proxy(ListEntitledApplicationsPaginated, request)
            def createStreamingURL(request: CreateStreamingUrlRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly
            ] = proxy(CreateStreamingURL, request)
            def updateEntitlement(request: UpdateEntitlementRequest): IO[
              AwsError,
              zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly
            ] = proxy(UpdateEntitlement, request)
            def disableUser(request: DisableUserRequest): IO[
              AwsError,
              zio.aws.appstream.model.DisableUserResponse.ReadOnly
            ] = proxy(DisableUser, request)
            def disassociateFleet(request: DisassociateFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.DisassociateFleetResponse.ReadOnly
            ] = proxy(DisassociateFleet, request)
            def createAppBlock(request: CreateAppBlockRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly
            ] = proxy(CreateAppBlock, request)
            def disassociateApplicationFromEntitlement(
                request: DisassociateApplicationFromEntitlementRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.ReadOnly
            ] = proxy(DisassociateApplicationFromEntitlement, request)
            def describeUsers(
                request: DescribeUsersRequest
            ): ZStream[Any, AwsError, zio.aws.appstream.model.User.ReadOnly] =
              rts.unsafeRun(proxy(DescribeUsers, request))
            def describeUsersPaginated(request: DescribeUsersRequest): IO[
              AwsError,
              zio.aws.appstream.model.DescribeUsersResponse.ReadOnly
            ] = proxy(DescribeUsersPaginated, request)
            def describeApplicationFleetAssociations(
                request: DescribeApplicationFleetAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeApplicationFleetAssociations, request))
            def describeApplicationFleetAssociationsPaginated(
                request: DescribeApplicationFleetAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly
            ] = proxy(DescribeApplicationFleetAssociationsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.appstream.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createImageBuilderStreamingURL(
                request: CreateImageBuilderStreamingUrlRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.ReadOnly
            ] = proxy(CreateImageBuilderStreamingURL, request)
            def startImageBuilder(request: StartImageBuilderRequest): IO[
              AwsError,
              zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly
            ] = proxy(StartImageBuilder, request)
            def describeApplications(
                request: DescribeApplicationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.Application.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeApplications, request))
            def describeApplicationsPaginated(
                request: DescribeApplicationsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly
            ] = proxy(DescribeApplicationsPaginated, request)
            def enableUser(request: EnableUserRequest): IO[
              AwsError,
              zio.aws.appstream.model.EnableUserResponse.ReadOnly
            ] = proxy(EnableUser, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.appstream.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def copyImage(request: CopyImageRequest): IO[
              AwsError,
              zio.aws.appstream.model.CopyImageResponse.ReadOnly
            ] = proxy(CopyImage, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.appstream.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteUser(request: DeleteUserRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteUserResponse.ReadOnly
            ] = proxy(DeleteUser, request)
            def listAssociatedFleets(
                request: ListAssociatedFleetsRequest
            ): ZStream[Any, AwsError, String] =
              rts.unsafeRun(proxy(ListAssociatedFleets, request))
            def listAssociatedFleetsPaginated(
                request: ListAssociatedFleetsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly
            ] = proxy(ListAssociatedFleetsPaginated, request)
            def updateStack(
                request: UpdateStackRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateStack, request)
            def deleteStack(request: DeleteStackRequest): IO[
              AwsError,
              zio.aws.appstream.model.DeleteStackResponse.ReadOnly
            ] = proxy(DeleteStack, request)
            def updateImagePermissions(
                request: UpdateImagePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.UpdateImagePermissionsResponse.ReadOnly
            ] = proxy(UpdateImagePermissions, request)
            def deleteImagePermissions(
                request: DeleteImagePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DeleteImagePermissionsResponse.ReadOnly
            ] = proxy(DeleteImagePermissions, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def createStack(request: CreateStackRequest): IO[
              AwsError,
              zio.aws.appstream.model.CreateStackResponse.ReadOnly
            ] = proxy(CreateStack, request)
            def batchDisassociateUserStack(
                request: BatchDisassociateUserStackRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly
            ] = proxy(BatchDisassociateUserStack, request)
            def describeUserStackAssociations(
                request: DescribeUserStackAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.UserStackAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeUserStackAssociations, request))
            def describeUserStackAssociationsPaginated(
                request: DescribeUserStackAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly
            ] = proxy(DescribeUserStackAssociationsPaginated, request)
            def listAssociatedStacks(
                request: ListAssociatedStacksRequest
            ): ZStream[Any, AwsError, String] =
              rts.unsafeRun(proxy(ListAssociatedStacks, request))
            def listAssociatedStacksPaginated(
                request: ListAssociatedStacksRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.ListAssociatedStacksResponse.ReadOnly
            ] = proxy(ListAssociatedStacksPaginated, request)
            def describeDirectoryConfigs(
                request: DescribeDirectoryConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appstream.model.DirectoryConfig.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeDirectoryConfigs, request))
            def describeDirectoryConfigsPaginated(
                request: DescribeDirectoryConfigsRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly
            ] = proxy(DescribeDirectoryConfigsPaginated, request)
            def stopFleet(request: StopFleetRequest): IO[
              AwsError,
              zio.aws.appstream.model.StopFleetResponse.ReadOnly
            ] = proxy(StopFleet, request)
            def updateDirectoryConfig(
                request: UpdateDirectoryConfigRequest
            ): IO[
              AwsError,
              zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly
            ] = proxy(UpdateDirectoryConfig, request)
          }
        }
      }
    }
  }
}
