package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  Arn,
  Integer,
  Description,
  UsbDeviceFilterString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFleetRequest(
    imageName: Optional[String] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    computeCapacity: Optional[zio.aws.appstream.model.ComputeCapacity] =
      Optional.Absent,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    maxUserDurationInSeconds: Optional[Integer] = Optional.Absent,
    disconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    deleteVpcConfig: Optional[Boolean] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    domainJoinInfo: Optional[zio.aws.appstream.model.DomainJoinInfo] =
      Optional.Absent,
    idleDisconnectTimeoutInSeconds: Optional[Integer] = Optional.Absent,
    attributesToDelete: Optional[
      Iterable[zio.aws.appstream.model.FleetAttribute]
    ] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    streamView: Optional[zio.aws.appstream.model.StreamView] = Optional.Absent,
    platform: Optional[zio.aws.appstream.model.PlatformType] = Optional.Absent,
    maxConcurrentSessions: Optional[Integer] = Optional.Absent,
    usbDeviceFilterStrings: Optional[Iterable[UsbDeviceFilterString]] =
      Optional.Absent,
    sessionScriptS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateFleetRequest = {
    import UpdateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
      .builder()
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(computeCapacity.map(value => value.buildAwsValue()))(
        _.computeCapacity
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        maxUserDurationInSeconds.map(value => value: java.lang.Integer)
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.disconnectTimeoutInSeconds)
      .optionallyWith(deleteVpcConfig.map(value => value: java.lang.Boolean))(
        _.deleteVpcConfig
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        attributesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributesToDeleteWithStrings)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value => value: java.lang.Integer)
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .optionallyWith(
        sessionScriptS3Location.map(value => value.buildAwsValue())
      )(_.sessionScriptS3Location)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateFleetRequest.ReadOnly =
    zio.aws.appstream.model.UpdateFleetRequest.wrap(buildAwsValue())
}
object UpdateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateFleetRequest =
      zio.aws.appstream.model.UpdateFleetRequest(
        imageName.map(value => value),
        imageArn.map(value => value),
        name.map(value => value),
        instanceType.map(value => value),
        computeCapacity.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        deleteVpcConfig.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        idleDisconnectTimeoutInSeconds.map(value => value),
        attributesToDelete.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value),
        sessionScriptS3Location.map(value => value.asEditable)
      )
    def imageName: Optional[String]
    def imageArn: Optional[Arn]
    def name: Optional[String]
    def instanceType: Optional[String]
    def computeCapacity
        : Optional[zio.aws.appstream.model.ComputeCapacity.ReadOnly]
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def maxUserDurationInSeconds: Optional[Integer]
    def disconnectTimeoutInSeconds: Optional[Integer]
    def deleteVpcConfig: Optional[Boolean]
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def idleDisconnectTimeoutInSeconds: Optional[Integer]
    def attributesToDelete
        : Optional[List[zio.aws.appstream.model.FleetAttribute]]
    def iamRoleArn: Optional[Arn]
    def streamView: Optional[zio.aws.appstream.model.StreamView]
    def platform: Optional[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Optional[Integer]
    def usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]]
    def sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getComputeCapacity
        : ZIO[Any, AwsError, zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      AwsError.unwrapOptionField("computeCapacity", computeCapacity)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getDeleteVpcConfig: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteVpcConfig", deleteVpcConfig)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getAttributesToDelete
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.FleetAttribute]] =
      AwsError.unwrapOptionField("attributesToDelete", attributesToDelete)
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
    def getSessionScriptS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField(
        "sessionScriptS3Location",
        sessionScriptS3Location
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ) extends zio.aws.appstream.model.UpdateFleetRequest.ReadOnly {
    override val imageName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => value: String)
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val computeCapacity
        : Optional[zio.aws.appstream.model.ComputeCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeCapacity())
        .map(value => zio.aws.appstream.model.ComputeCapacity.wrap(value))
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val maxUserDurationInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxUserDurationInSeconds())
        .map(value => value: Integer)
    override val disconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val deleteVpcConfig: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteVpcConfig())
      .map(value => value: Boolean)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainJoinInfo())
        .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val idleDisconnectTimeoutInSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleDisconnectTimeoutInSeconds())
        .map(value => value: Integer)
    override val attributesToDelete
        : Optional[List[zio.aws.appstream.model.FleetAttribute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.FleetAttribute.wrap(item)
          }.toList
        )
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Optional[zio.aws.appstream.model.StreamView] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamView())
        .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Optional[zio.aws.appstream.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrentSessions())
        .map(value => value: Integer)
    override val usbDeviceFilterStrings: Optional[List[UsbDeviceFilterString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
    override val sessionScriptS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionScriptS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetRequest
  ): zio.aws.appstream.model.UpdateFleetRequest.ReadOnly = new Wrapper(impl)
}
