package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{S3Key, S3Bucket}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Location(s3Bucket: S3Bucket, s3Key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.S3Location
      .builder()
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .s3Key(S3Key.unwrap(s3Key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.S3Location.ReadOnly =
    zio.aws.appstream.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.S3Location =
      zio.aws.appstream.model.S3Location(s3Bucket, s3Key)
    def s3Bucket: S3Bucket
    def s3Key: S3Key
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3Key: ZIO[Any, Nothing, S3Key] = ZIO.succeed(s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.S3Location
  ) extends zio.aws.appstream.model.S3Location.ReadOnly {
    override val s3Bucket: S3Bucket =
      zio.aws.appstream.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3Key: S3Key =
      zio.aws.appstream.model.primitives.S3Key(impl.s3Key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.S3Location
  ): zio.aws.appstream.model.S3Location.ReadOnly = new Wrapper(impl)
}
