package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkAccessConfiguration(
    eniPrivateIpAddress: Optional[String] = Optional.Absent,
    eniId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration = {
    import NetworkAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
      .builder()
      .optionallyWith(
        eniPrivateIpAddress.map(value => value: java.lang.String)
      )(_.eniPrivateIpAddress)
      .optionallyWith(eniId.map(value => value: java.lang.String))(_.eniId)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly =
    zio.aws.appstream.model.NetworkAccessConfiguration.wrap(buildAwsValue())
}
object NetworkAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.NetworkAccessConfiguration =
      zio.aws.appstream.model.NetworkAccessConfiguration(
        eniPrivateIpAddress.map(value => value),
        eniId.map(value => value)
      )
    def eniPrivateIpAddress: Optional[String]
    def eniId: Optional[String]
    def getEniPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eniPrivateIpAddress", eniPrivateIpAddress)
    def getEniId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eniId", eniId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ) extends zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly {
    override val eniPrivateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eniPrivateIpAddress())
      .map(value => value: String)
    override val eniId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eniId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ): zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
