package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationAttribute {
  def unwrap
      : software.amazon.awssdk.services.appstream.model.ApplicationAttribute
}
object ApplicationAttribute {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.ApplicationAttribute
  ): zio.aws.appstream.model.ApplicationAttribute = value match {
    case software.amazon.awssdk.services.appstream.model.ApplicationAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.ApplicationAttribute.LAUNCH_PARAMETERS =>
      val r = LAUNCH_PARAMETERS
      r
    case software.amazon.awssdk.services.appstream.model.ApplicationAttribute.WORKING_DIRECTORY =>
      val r = WORKING_DIRECTORY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.ApplicationAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ApplicationAttribute =
      software.amazon.awssdk.services.appstream.model.ApplicationAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object LAUNCH_PARAMETERS
      extends zio.aws.appstream.model.ApplicationAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ApplicationAttribute =
      software.amazon.awssdk.services.appstream.model.ApplicationAttribute.LAUNCH_PARAMETERS
  }
  case object WORKING_DIRECTORY
      extends zio.aws.appstream.model.ApplicationAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ApplicationAttribute =
      software.amazon.awssdk.services.appstream.model.ApplicationAttribute.WORKING_DIRECTORY
  }
}
