package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait ImageBuilderStateChangeReasonCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode
}
object ImageBuilderStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode
  ): zio.aws.appstream.model.ImageBuilderStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.IMAGE_UNAVAILABLE =>
      val r = IMAGE_UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.ImageBuilderStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.appstream.model.ImageBuilderStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.INTERNAL_ERROR
  }
  case object IMAGE_UNAVAILABLE
      extends zio.aws.appstream.model.ImageBuilderStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReasonCode.IMAGE_UNAVAILABLE
  }
}
