package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, UserId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSessionsRequest(
    stackName: String,
    fleetName: String,
    userId: Optional[UserId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    limit: Optional[Integer] = Optional.Absent,
    authenticationType: Optional[zio.aws.appstream.model.AuthenticationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest = {
    import DescribeSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
      .builder()
      .stackName(stackName: java.lang.String)
      .fleetName(fleetName: java.lang.String)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => value: java.lang.Integer))(_.limit)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeSessionsRequest.wrap(buildAwsValue())
}
object DescribeSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeSessionsRequest =
      zio.aws.appstream.model.DescribeSessionsRequest(
        stackName,
        fleetName,
        userId.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value),
        authenticationType.map(value => value)
      )
    def stackName: String
    def fleetName: String
    def userId: Optional[UserId]
    def nextToken: Optional[String]
    def limit: Optional[Integer]
    def authenticationType: Optional[zio.aws.appstream.model.AuthenticationType]
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appstream.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ) extends zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly {
    override val stackName: String = impl.stackName(): String
    override val fleetName: String = impl.fleetName(): String
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.appstream.model.primitives.UserId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val limit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: Integer)
    override val authenticationType
        : Optional[zio.aws.appstream.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.appstream.model.AuthenticationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest
  ): zio.aws.appstream.model.DescribeSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
