package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateUserStackResponse(
    errors: Optional[
      Iterable[zio.aws.appstream.model.UserStackAssociationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse = {
    import BatchDisassociateUserStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly =
    zio.aws.appstream.model.BatchDisassociateUserStackResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateUserStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.BatchDisassociateUserStackResponse =
      zio.aws.appstream.model.BatchDisassociateUserStackResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.appstream.model.UserStackAssociationError.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserStackAssociationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse
  ) extends zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.appstream.model.UserStackAssociationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UserStackAssociationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse
  ): zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly =
    new Wrapper(impl)
}
