package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplicationFleetAssociation(
    fleetName: String,
    applicationArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation = {
    import ApplicationFleetAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation
      .builder()
      .fleetName(fleetName: java.lang.String)
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly =
    zio.aws.appstream.model.ApplicationFleetAssociation.wrap(buildAwsValue())
}
object ApplicationFleetAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ApplicationFleetAssociation =
      zio.aws.appstream.model
        .ApplicationFleetAssociation(fleetName, applicationArn)
    def fleetName: String
    def applicationArn: Arn
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation
  ) extends zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly {
    override val fleetName: String = impl.fleetName(): String
    override val applicationArn: Arn =
      zio.aws.appstream.model.primitives.Arn(impl.applicationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation
  ): zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly = new Wrapper(
    impl
  )
}
