package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  BooleanObject,
  TagValue,
  AppstreamAgentVersion,
  Arn,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateImageBuilderRequest(
    name: Name,
    imageName: Optional[String] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    instanceType: String,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    vpcConfig: Optional[zio.aws.appstream.model.VpcConfig] = Optional.Absent,
    iamRoleArn: Optional[Arn] = Optional.Absent,
    enableDefaultInternetAccess: Optional[BooleanObject] = Optional.Absent,
    domainJoinInfo: Optional[zio.aws.appstream.model.DomainJoinInfo] =
      Optional.Absent,
    appstreamAgentVersion: Optional[AppstreamAgentVersion] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest = {
    import CreateImageBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        appstreamAgentVersion.map(value =>
          AppstreamAgentVersion.unwrap(value): java.lang.String
        )
      )(_.appstreamAgentVersion)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateImageBuilderRequest.ReadOnly =
    zio.aws.appstream.model.CreateImageBuilderRequest.wrap(buildAwsValue())
}
object CreateImageBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateImageBuilderRequest =
      zio.aws.appstream.model.CreateImageBuilderRequest(
        name,
        imageName.map(value => value),
        imageArn.map(value => value),
        instanceType,
        description.map(value => value),
        displayName.map(value => value),
        vpcConfig.map(value => value.asEditable),
        iamRoleArn.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        appstreamAgentVersion.map(value => value),
        tags.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def imageName: Optional[String]
    def imageArn: Optional[Arn]
    def instanceType: String
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def vpcConfig: Optional[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def iamRoleArn: Optional[Arn]
    def enableDefaultInternetAccess: Optional[BooleanObject]
    def domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def appstreamAgentVersion: Optional[AppstreamAgentVersion]
    def tags: Optional[Map[TagKey, TagValue]]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getAppstreamAgentVersion: ZIO[Any, AwsError, AppstreamAgentVersion] =
      AwsError.unwrapOptionField("appstreamAgentVersion", appstreamAgentVersion)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest
  ) extends zio.aws.appstream.model.CreateImageBuilderRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val imageName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => value: String)
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val instanceType: String = impl.instanceType(): String
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val vpcConfig
        : Optional[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val iamRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val enableDefaultInternetAccess: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDefaultInternetAccess())
        .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Optional[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainJoinInfo())
        .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val appstreamAgentVersion: Optional[AppstreamAgentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appstreamAgentVersion())
        .map(value =>
          zio.aws.appstream.model.primitives.AppstreamAgentVersion(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest
  ): zio.aws.appstream.model.CreateImageBuilderRequest.ReadOnly = new Wrapper(
    impl
  )
}
