package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    name: Name,
    displayName: Optional[DisplayName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    iconS3Location: zio.aws.appstream.model.S3Location,
    launchPath: String,
    workingDirectory: Optional[String] = Optional.Absent,
    launchParameters: Optional[String] = Optional.Absent,
    platforms: Iterable[zio.aws.appstream.model.PlatformType],
    instanceFamilies: Iterable[String],
    appBlockArn: Arn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .iconS3Location(iconS3Location.buildAwsValue())
      .launchPath(launchPath: java.lang.String)
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(launchParameters.map(value => value: java.lang.String))(
        _.launchParameters
      )
      .platformsWithStrings(platforms.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .instanceFamilies(instanceFamilies.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .appBlockArn(Arn.unwrap(appBlockArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateApplicationRequest.ReadOnly =
    zio.aws.appstream.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateApplicationRequest =
      zio.aws.appstream.model.CreateApplicationRequest(
        name,
        displayName.map(value => value),
        description.map(value => value),
        iconS3Location.asEditable,
        launchPath,
        workingDirectory.map(value => value),
        launchParameters.map(value => value),
        platforms,
        instanceFamilies,
        appBlockArn,
        tags.map(value => value)
      )
    def name: Name
    def displayName: Optional[DisplayName]
    def description: Optional[Description]
    def iconS3Location: zio.aws.appstream.model.S3Location.ReadOnly
    def launchPath: String
    def workingDirectory: Optional[String]
    def launchParameters: Optional[String]
    def platforms: List[zio.aws.appstream.model.PlatformType]
    def instanceFamilies: List[String]
    def appBlockArn: Arn
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIconS3Location
        : ZIO[Any, Nothing, zio.aws.appstream.model.S3Location.ReadOnly] =
      ZIO.succeed(iconS3Location)
    def getLaunchPath: ZIO[Any, Nothing, String] = ZIO.succeed(launchPath)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getLaunchParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchParameters", launchParameters)
    def getPlatforms
        : ZIO[Any, Nothing, List[zio.aws.appstream.model.PlatformType]] =
      ZIO.succeed(platforms)
    def getInstanceFamilies: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(instanceFamilies)
    def getAppBlockArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(appBlockArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateApplicationRequest
  ) extends zio.aws.appstream.model.CreateApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val iconS3Location: zio.aws.appstream.model.S3Location.ReadOnly =
      zio.aws.appstream.model.S3Location.wrap(impl.iconS3Location())
    override val launchPath: String = impl.launchPath(): String
    override val workingDirectory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workingDirectory())
      .map(value => value: String)
    override val launchParameters: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchParameters())
      .map(value => value: String)
    override val platforms: List[zio.aws.appstream.model.PlatformType] = impl
      .platforms()
      .asScala
      .map { item =>
        zio.aws.appstream.model.PlatformType.wrap(item)
      }
      .toList
    override val instanceFamilies: List[String] = impl
      .instanceFamilies()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val appBlockArn: Arn =
      zio.aws.appstream.model.primitives.Arn(impl.appBlockArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appstream.model.primitives
              .TagKey(key) -> zio.aws.appstream.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateApplicationRequest
  ): zio.aws.appstream.model.CreateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
