package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Description, RegionName, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyImageRequest(
    sourceImageName: Name,
    destinationImageName: Name,
    destinationRegion: RegionName,
    destinationImageDescription: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CopyImageRequest = {
    import CopyImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CopyImageRequest
      .builder()
      .sourceImageName(Name.unwrap(sourceImageName): java.lang.String)
      .destinationImageName(Name.unwrap(destinationImageName): java.lang.String)
      .destinationRegion(RegionName.unwrap(destinationRegion): java.lang.String)
      .optionallyWith(
        destinationImageDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.destinationImageDescription)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CopyImageRequest.ReadOnly =
    zio.aws.appstream.model.CopyImageRequest.wrap(buildAwsValue())
}
object CopyImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CopyImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CopyImageRequest =
      zio.aws.appstream.model.CopyImageRequest(
        sourceImageName,
        destinationImageName,
        destinationRegion,
        destinationImageDescription.map(value => value)
      )
    def sourceImageName: Name
    def destinationImageName: Name
    def destinationRegion: RegionName
    def destinationImageDescription: Optional[Description]
    def getSourceImageName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(sourceImageName)
    def getDestinationImageName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(destinationImageName)
    def getDestinationRegion: ZIO[Any, Nothing, RegionName] =
      ZIO.succeed(destinationRegion)
    def getDestinationImageDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField(
        "destinationImageDescription",
        destinationImageDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CopyImageRequest
  ) extends zio.aws.appstream.model.CopyImageRequest.ReadOnly {
    override val sourceImageName: Name =
      zio.aws.appstream.model.primitives.Name(impl.sourceImageName())
    override val destinationImageName: Name =
      zio.aws.appstream.model.primitives.Name(impl.destinationImageName())
    override val destinationRegion: RegionName =
      zio.aws.appstream.model.primitives.RegionName(impl.destinationRegion())
    override val destinationImageDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationImageDescription())
        .map(value => zio.aws.appstream.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CopyImageRequest
  ): zio.aws.appstream.model.CopyImageRequest.ReadOnly = new Wrapper(impl)
}
